<?php
/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    PrestaHeroes <info@prestaheroes.com>
*  @copyright 2016 Heroic Business Solutions LLC
*  @license   commercial
*/

if (!defined('_PS_VERSION_')) {
    exit;
}
include_once(dirname(__FILE__).'/lib/classes/vendor/autoload.php');

class GeoTargetingPro extends Module
{
    private $html = '';
    const __GTP_BLACK_LIST_DELIM__ = ',';
    private $blacklist;
    private static $city_file = 'GeoLiteCity.dat';
    public function __construct()
    {
        $this->name = 'geotargetingpro';
        $this->tab = 'administration';
        $this->version = '5.2.4';
        $this->author = 'PrestaHeroes';
        $this->bootstrap = true;
        $this->ps_versions_compliancy = array('min' => '1.6.0.9', 'max' => _PS_VERSION_);
        $this->module_key = 'acd0e329d3aa115de17be54f5e5cac0f';

        parent::__construct();

        $this->displayName = $this->l('Geo Targeting Pro');
        $this->description = $this->l(
            'PrestaShop Geolocalization Extension.  Control Non-Resolved IP | Simulate Country | Black List'
        );

        if (Configuration::get('GTP_IPSIMULATOR')) {
            $this->warning .= $this->l(
                'Geo Targeting Pro Country Simulator Active | Disable when not in use.'
            );
        }
        $primary = (int) Configuration::get('GTP_PRIMARY_LOOKUP');
        if (file_exists(_PS_GEOIP_DIR_.self::$city_file) && $primary == 0) {
            if ((time()-@filemtime(_PS_GEOIP_DIR_.self::$city_file) > 45 * 24 * 3600)) {
                $this->warning .= $this->displayGTPhtml(5);
            }
        }
        if (file_exists(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb') && $primary == 1) {
            if ((time()-@filemtime(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb') > 15 * 24 * 3600)) {
                $this->warning .= $this->displayGTPhtml(6);
            }
        }
    }

    public function install()
    {
        if (_PS_MODE_DEMO_) {
            return false;
        }
        if (!parent::install()) {
            return false;
        }
        $this->preInstallChecks();
        $this->registerHook('backOfficeHeader');
        $this->setDefaults();
        return true;
    }

    private function preInstallChecks()
    {
        if (Tools::substr(_PS_VERSION_, 0, 3) < 1.5) {
            Module::uninstall($this->name);
            die(Tools::displayError('Module not compatible with your PrestaShop version: '._PS_VERSION_));
        }
    }

    private function setDefaults()
    {
        Configuration::updateValue('GTP_IPSIMULATOR', false);
        Configuration::updateValue('GTP_DEFAULT_COUNTRY', 0);
        Configuration::updateValue('GTP_SYMTYPE', 0);
        Configuration::updateValue('GTP_IP2_SIMULATE', false);
        Configuration::updateValue('GTP_COUNTRY2_SIMULATE', null);
        Configuration::updateValue('GTP_ORG_IP_ADDR', Tools::getRemoteAddr());
        Configuration::updateValue('GTP_BLACK_LIST', null);
        Configuration::updateValue('GTP_IP_CITY_INFO', Tools::getRemoteAddr());
        Configuration::updateValue('GTP_PRIMARY_LOOKUP', 0);
        Configuration::updateValue('GTP_MM_USER_ID', '');
        Configuration::updateValue('GTP_MM_LICENSE_KEY', '');
        Configuration::updateValue('GTP_GEO_STATS', false);
        Configuration::updateValue('GTP_GEO_STATS_CLEAR', false);
        Configuration::updateValue('GTP_STAT_TOTAL', 0);
        Configuration::updateValue('GTP_STAT_RESOLVED', 0);
        Configuration::updateValue('GTP_STAT_NON_RESOLVED', 0);
        Configuration::updateValue('GTP_STAT_LAST_CLEAR_DATE', 0);
        Configuration::updateValue('GTP_ADDRESS_OVERRIDE', 1);
        Configuration::updateValue('GTP_ACTIVE_TAB', '#config');
    }
    public function hookBackOfficeHeader()
    {
        if (Tools::getValue('controller') == 'AdminModules' &&
             (Tools::getValue('configure') == $this->name || Tools::getValue('module_name') == $this->name)
        ) {
            $this->context->controller->addJquery();
            $this->context->controller->addJS($this->_path.'views/js/back.js');
        }
    }
    public function uninstall()
    {
        if (_PS_MODE_DEMO_) {
            return false;
        }
        if (!parent::uninstall()) {
            return false;
        }
        $this->deleteSettings();
        return true;
    }
    private function deleteSettings()
    {
        Configuration::deleteByName('GTP_IPSIMULATOR');
        Configuration::deleteByName('GTP_DEFAULT_COUNTRY');
        Configuration::deleteByName('GTP_SYMTYPE');
        Configuration::deleteByName('GTP_IP2_SIMULATE');
        Configuration::deleteByName('GTP_COUNTRY2_SIMULATE');
        Configuration::deleteByName('GTP_ORG_IP_ADDR');
        Configuration::deleteByName('GTP_BLACK_LIST');
        Configuration::deleteByName('GTP_IP_CITY_INFO');
        Configuration::deleteByName('GTP_PRIMARY_LOOKUP');
        Configuration::deleteByName('GTP_MM_USER_ID');
        Configuration::deleteByName('GTP_MM_LICENSE_KEY');
        Configuration::deleteByName('GTP_GEO_STATS');
        Configuration::deleteByName('GTP_GEO_STATS_CLEAR');
        Configuration::deleteByName('GTP_STAT_TOTAL');
        Configuration::deleteByName('GTP_STAT_RESOLVED');
        Configuration::deleteByName('GTP_STAT_NON_RESOLVED');
        Configuration::deleteByName('GTP_STAT_LAST_CLEAR_DATE');
        Configuration::deleteByName('GTP_ADDRESS_OVERRIDE');
        Configuration::deleteByName('GTP_ACTIVE_TAB');
    }
    public function disable($force_all = false)
    {
        if (_PS_MODE_DEMO_) {
            return false;
        }
        if (!parent::disable($force_all)) {
            return false;
        }
        return true;
    }
    public function enable($force_all = false)
    {
        if (_PS_MODE_DEMO_) {
            return false;
        }
        if (!parent::enable($force_all)) {
            return false;
        }
        return true;
    }
    public function getContent()
    {
        $this->html = $this->postProcess();
        $primary = (int) Configuration::get('GTP_PRIMARY_LOOKUP');
        if (file_exists(_PS_GEOIP_DIR_.self::$city_file)  && $primary == 0) {
            if (time()-filemtime(_PS_GEOIP_DIR_.self::$city_file) > 45 * 24 * 3600) {
                $this->html .= $this->displayWarning($this->displayGTPhtml(1));
            }
        }
        if (file_exists(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb') && $primary == 1) {
            if (time()-filemtime(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb') > 15 * 24 * 3600) {
                $this->html .= $this->displayWarning($this->displayGTPhtml(4));
            }
        }
        if (Configuration::get('PS_DETECT_COUNTRY')) {
            $this->html .= $this->displayWarning($this->displayGTPhtml(2));
        }
        if (!Configuration::get('PS_GEOLOCATION_ENABLED')) {
            return $this->html .= $this->displayWarning($this->displayGTPhtml(3));
        } else {
            $this->html .= $this->renderConfigForm();
        }
        $ajaxlink = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;

        $this->html .= $this->displayGTPhtml(
            100,
            Tools::getRemoteAddr(),
            $ajaxlink,
            Tools::getAdminTokenLite('AdminModules')
        );
        return $this->html;
    }
    protected function displayGTPhtml($message, $param1 = null, $param2 = null, $param3 = null, $param4 = null)
    {

        if ($message) {
            $this->smarty->assign(array(
                'message' => $message,
                'param1' => $param1,
                'param2' => $param2,
                'param3' => $param3,
                'param4' => $param4
            ));
            return $this->display(__FILE__, 'views/templates/admin/infos.tpl');
        }
    }
    protected function renderConfigForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitGeoTargetPro';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm($this->getConfigForm());
    }
    public function ajaxProcessGetGeoStats()
    {
        echo json_encode(array(
            'total' => (int) Configuration::get('GTP_STAT_TOTAL'),
            'resolved' =>(int) Configuration::get('GTP_STAT_RESOLVED'),
            'nonResolved' => (int) Configuration::get('GTP_STAT_NON_RESOLVED'),
            'lastClearDate' => Configuration::get('GTP_STAT_LAST_CLEAR_DATE'),
            'resolved_percent' =>((int) Configuration::get('GTP_STAT_TOTAL') > 0 ? number_format(
                100*(int) Configuration::get('GTP_STAT_RESOLVED')/(int) Configuration::get('GTP_STAT_TOTAL'),
                2,
                '.',
                ''
            ) : 0),
            'non_resolved_percent' => ((int) Configuration::get('GTP_STAT_TOTAL') > 0 ? number_format(
                100*(int) Configuration::get('GTP_STAT_NON_RESOLVED')/(int) Configuration::get('GTP_STAT_TOTAL'),
                2,
                '.',
                ''
            ) : 0)
        ));
    }
    protected function getConfigForm()
    {
        $ip_city_info = Configuration::get('GTP_IP_CITY_INFO');
        $returned_data = $this->getGeoObjectByIP($ip_city_info);
        $diff = time()- @filemtime(_PS_GEOIP_DIR_.self::$city_file);
        $diff_country = time()- @filemtime(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb');
        $days_geo_lite_city = round($diff/86400);
        $days_geo_country = 0;
        $diff_country = 0;
        if (file_exists(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb')) {
            $diff_country = time()-@filemtime(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb');
            $days_geo_country = round($diff_country/86400);
        }
        $nonresolved = Country::getCountries((int)Context::getContext()->language->id, true, false, false);
        $nonresolved[] = array(
            'id_country' => 0,
            'iso_code' => '0',
            'name' => $this->l('- Default Native PrestaShop (no shopping) -')
        );
        $geoStatsData = array(
            'total' => (int) Configuration::get('GTP_STAT_TOTAL'),
            'resolved' =>(int) Configuration::get('GTP_STAT_RESOLVED'),
            'nonResolved' => (int) Configuration::get('GTP_STAT_NON_RESOLVED'),
            'lastClearDate' => Configuration::get('GTP_STAT_LAST_CLEAR_DATE'),
        );
        $resolved_percent = ($geoStatsData['total'] > 0 ? number_format(
            100*$geoStatsData['resolved']/$geoStatsData['total'],
            2,
            '.',
            ''
        ) : 0);
        $this->context->smarty->assign('this_path', $this->_path);
        $guidehtml = $this->context->smarty->fetch($this->local_path.'views/templates/admin/guide.tpl');
        $primary = (int) Configuration::get('GTP_PRIMARY_LOOKUP');

        $non_resolved_form = array(
            'form' => array(
                'id_form' => 'gtp_form',
                'legend' => array(
                    'title' => $this->l(
                        'Geo Targeting Pro module configuration'
                    ),
                    'icon' => 'icon-map-marker'
                ),
                'tabs' => array(
                    'config' => $this->l('Configuration'),
                    'geoipdb' => $this->l('GEO IP source'),
                    'simulator' => $this->l('Country Simulator'),
                    'black-list' => $this->l('Black Listed IP(s)'),
                    'resolve-ip' => $this->l('Resolve IP'),
                    'advanced_ietf' => $this->l('Advanced IETF'),
                    'stats' => $this->l('Geo Insight'),
                    'docs' => $this->l('User Guide'),
                 ),
                'description' => (Configuration::get('GTP_IPSIMULATOR')? $this->l(
                    'Geo Targeting Pro Country Simulator Enabled.  Disable when not using.'
                ): ''),
                'input' => array(
                    array(
                        'type' => 'hidden',
                        'lang' => false,
                        'class' => 'input active-tab-input',
                        'name' => 'GTP_ACTIVE_TAB',
                    ),
                    array(
                        'label' => $this->l(
                            'Default country for non-resolved IP(s)'
                        ),
                        'type' => 'select',
                        'class' => 'fixed-width-xxl',
                        'name' => 'GTP_DEFAULT_COUNTRY',
                        'tab' => 'config',
                        'options' => array(
                            'query' => $nonresolved,
                            'name' => 'name',
                            'id' => 'iso_code'
                        )
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_info',
                        'tab' => 'config',
                        'html_content' => (!(bool)Configuration::get('GTP_DEFAULT_COUNTRY')?
                            $this->displayError($this->displayGTPhtml(7, $this->behavior())): '')
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Address override'),
                        'name' => 'GTP_ADDRESS_OVERRIDE',
                        'hint' => $this->l(
                            'Override login country by IP country.'
                        ),
                        'tab' => 'config',
                        'values' => array(
                            array(
                                'id' => 'GTP_ADDRESS_OVERRIDE_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'GTP_ADDRESS_OVERRIDE_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'radio',
                        'label' => $this->l('Primary lookup'),
                        'name' => 'GTP_PRIMARY_LOOKUP',
                        'tab' => 'geoipdb',
                        'hint' => $this->l(
                            'Choose MaxMind database native/free or commercial one.'
                        ),
                        'values' => array(
                            array(
                                'id' => 'GTP_PRIMARY_LOOKUP_0',
                                'value' => 0,
                                'label' => $this->l(
                                    'Default native geo data from MaxMind'
                                )
                            ),
                            array(
                                'id' => 'GTP_PRIMARY_LOOKUP_1',
                                'value' => 1,
                                'label' => $this->l(
                                    'MaxMind GeoIP2 Country database'
                                )
                            ),
                            array(
                                'id' => 'GTP_PRIMARY_LOOKUP_2',
                                'value' => 2,
                                'label' => $this->l(
                                    'MaxMind GeoIP2 Precision Country database'
                                )
                            )
                        )
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_info',
                        'tab' => 'geoipdb',
                        'html_content' => $this->displayGTPhtml(8)
                    ),
                    array(
                        'label' => $this->l('MaxMind User ID'),
                        'type' => 'text',
                        'lang' => false,
                        'class' => 'input fixed-width-xxl',
                        'required' => false,
                        'tab' => 'geoipdb',
                        'name' => 'GTP_MM_USER_ID',
                    ),
                    array(
                        'label' => $this->l('MaxMind License key'),
                        'type' => 'text',
                        'lang' => false,
                        'class' => 'input fixed-width-xxl',
                        'required' => false,
                        'tab' => 'geoipdb',
                        'name' => 'GTP_MM_LICENSE_KEY',
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_info',
                        'tab' => 'geoipdb',
                        'html_content' => $this->displayGTPhtml(
                            9,
                            $days_geo_country,
                            Tools::formatBytes(Tools::getMaxUploadSize())
                        )
                    ),
                    array(
                        'type' => 'file',
                        'label' => $this->l('GeoIP2 Country database'),
                        'name' => 'GTP_GEOIP2_COUNTRY_FILE',
                        'tab' => 'geoipdb',
                        'desc' => $this->l(
                            'Select file you wish to import.'
                        )
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_info',
                        'tab' => 'simulator',
                        'html_content' => $this->displayGTPhtml(10)
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Enabled'),
                        'name' => 'GTP_IPSIMULATOR',
                        'tab' => 'simulator',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'radio',
                        'label' => $this->l('Simulator type'),
                        'name' => 'GTP_SYMTYPE',
                        'class' => 'simulator-type',
                        'tab' => 'simulator',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l(
                                    'Simulate IP (IP1,IP2,..)'
                                )
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l(
                                    'By Selected Country'
                                )
                            )
                        )
                    ),
                    array(
                        'label' => $this->l('Simulate IP (IP1,IP2,..)'),
                        'type' => 'text',
                        'lang' => false,
                        'class' => 'input fixed-width-xxl ip-simulator',
                        'required' => false,
                        'tab' => 'simulator',
                        'name' => 'GTP_IP2_SIMULATE',
                    ),
                    array(
                        'label' => $this->l('Simulate country'),
                        'type' => 'select',
                        'class' => 'country-simulator',
                        'required' => false,
                        'tab' => 'simulator',
                        'name'=> 'GTP_COUNTRY2_SIMULATE',
                        'options' => array(
                            'query' => Country::getCountries($this->context->language->id, false, false, false),
                            'name' => 'name',
                            'id' => 'iso_code'
                        )
                    ),
                    array(
                        'label' => $this->l(
                            'Browser IP(s) testing from:'
                        ),
                        'type' => 'text',
                        'lang' => false,
                        'class' => 'input fixed-width-xxl',
                        'required' => false,
                        'tab' => 'simulator',
                        'name' => 'GTP_ORG_IP_ADDR',
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_ip',
                        'tab' => 'simulator',
                        'html_content' => $this->displayGTPhtml(19)
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_native',
                        'tab' => 'black-list',
                        'html_content' => $this->displayGTPhtml(11)
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => '',
                        'name' => 'GTP_BLACK_LIST',
                        'tab' => 'black-list',
                        'lang' => false,
                        'cols' => 15,
                        'rows' => 30,
                        'class' => 'input fixed-width-xxl',
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_resolve',
                        'tab' => 'resolve-ip',
                        'html_content' => $this->displayGTPhtml(
                            12,
                            $primary,
                            $days_geo_lite_city,
                            $days_geo_country,
                            $returned_data
                        )
                    ),
                    array(
                        'label' => $this->l('Resolve IP:'),
                        'type' => 'text',
                        'lang' => false,
                        'class' => 'input fixed-width-xxl',
                        'required' => false,
                        'tab' => 'resolve-ip',
                        'name' => 'GTP_IP_CITY_INFO',
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_data_resolve',
                        'tab' => 'docs',
                        'html_content' => $guidehtml
                    ),
                    array(
                        'type' => 'hidden',
                        'label' => $this->l('Enable Geo Insight'),
                        'name' => 'GTP_GEO_STATS_CLEAR',
                        'tab' => 'stats',
                    ),
                    array(
                        'type' => 'switch',
                        'label' => $this->l('Enable Geo Insight'),
                        'name' => 'GTP_GEO_STATS',
                        'tab' => 'stats',
                        'values' => array(
                            array(
                                'id' => 'GTP_GEO_STATS_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'GTP_GEO_STATS_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'html',
                        'label' => $this->l('Clear Geo Insight'),
                        'tab' => 'stats',
                        'name' => 'GTP_GEO_STATS_CLEAR_BUTTON',
                        'html_content' => $this->displayGTPhtml(13)
                    ),
                    array(
                        'type' => 'html',
                        'label' => $this->l('Refresh Geo Insight'),
                        'tab' => 'stats',
                        'name' => 'GTP_GEO_STATS_REFRESH_BUTTON',
                        'html_content' => $this->displayGTPhtml(14)
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'html_stats_info',
                        'tab' => 'stats',
                        'label' => $this->l('Geo Resolve Insight'),
                        'hint' => $this->l(
                            'Percentage of all resolved IP'
                        ),
                        'html_content' => $this->displayGTPhtml(15, $resolved_percent)
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save')
                )
            ),
        );

        return array($non_resolved_form);
    }

    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {
        $ips = (string)Configuration::get('GTP_BLACK_LIST');
        $ips = str_replace(',', "\n", $ips);

        return array(
            'GTP_IPSIMULATOR' => (bool)Configuration::get('GTP_IPSIMULATOR', false),
            'GTP_DEFAULT_COUNTRY' => Configuration::get('GTP_DEFAULT_COUNTRY', null),
            'GTP_SYMTYPE' => (bool)Configuration::get('GTP_SYMTYPE', false),
            'GTP_IP2_SIMULATE' => Configuration::get('GTP_IP2_SIMULATE', false),
            'GTP_COUNTRY2_SIMULATE' => Configuration::get('GTP_COUNTRY2_SIMULATE', null),
            'GTP_ORG_IP_ADDR' => Configuration::get('GTP_ORG_IP_ADDR', Tools::getRemoteAddr()),
            'GTP_BLACK_LIST' => $ips,
            'GTP_IP_CITY_INFO' => Configuration::get('GTP_IP_CITY_INFO', false),
            'GTP_PRIMARY_LOOKUP' => Configuration::get('GTP_PRIMARY_LOOKUP'),
            'GTP_GEO_STATS' => (bool)Configuration::get('GTP_GEO_STATS', false),
            'GTP_GEO_STATS_CLEAR' => (bool)Configuration::get('GTP_GEO_STATS_CLEAR', false),
            'GTP_MM_USER_ID' => Configuration::get('GTP_MM_USER_ID', false),
            'GTP_MM_LICENSE_KEY' => Configuration::get('GTP_MM_LICENSE_KEY', false),
            'GTP_ADDRESS_OVERRIDE' => (bool)Configuration::get('GTP_ADDRESS_OVERRIDE', false),
            'GTP_ACTIVE_TAB' => Configuration::get('GTP_ACTIVE_TAB')
        );
    }
    public function getGeoObjectByIP($gip = '207.160.169.253')
    {
        $result = '';
        $isValidIp = filter_var($gip, FILTER_VALIDATE_IP);
        if (!$isValidIp) {
            return $this->displayError($gip . $this->l(
                ' is not valid IP address!'
            ));
        }
        if (file_exists(_PS_GEOIP_DIR_.self::$city_file) && isset($gip) && $gip && $isValidIp) {
            //$reader = new GeoIp2\Database\Reader(_PS_GEOIP_DIR_.self::$city_file);

            $primary = (int) Configuration::get('GTP_PRIMARY_LOOKUP');
            switch ($primary) {
                case 2:
                    try {
                        $userId = Configuration::get('GTP_MM_USER_ID');
                        $licenseKey = Configuration::get('GTP_MM_LICENSE_KEY');
                        $client = new GeoIp2\WebService\Client($userId, $licenseKey);
                        $crecord = $client->country($gip);
                        $result .= $this->displayGTPhtml(16, $crecord);
                    } catch (\GeoIp2\Exception\AuthenticationException $e) {
                        $result .= $this->l(
                            'Your user ID or license key could not be authenticated. '
                        );
                    }
                    break;
                case 1:
                    if (file_exists(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb')) {
                        try {
                            $creader = new GeoIp2\Database\Reader(
                                _PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb'
                            );
                            $crecord = $creader->country($gip);
                            $result .= $this->displayGTPhtml(17, $crecord);
                        } catch (\GeoIp2\Exception\AddressNotFoundException $e) {
                            $crecord = null;
                        }
                    }
                    break;
                default:
                    try {
                        include_once(_PS_GEOIP_DIR_.'geoipcity.inc');

                        $gi = geoip_open(realpath(_PS_GEOIP_DIR_.self::$city_file), GEOIP_STANDARD);
                        $record = geoip_record_by_addr($gi, $gip);
                        $result .= $this->displayGTPhtml(20, $record);
                    } catch (\GeoIp2\Exception\AddressNotFoundException $e) {
                        $record = null;
                    }
                    break;
            }
        }
        return $result;
    }

    private function behavior()
    {
        if (Configuration::get('PS_GEOLOCATION_BEHAVIOR')) {
            return $this->l(
                'Visitors can see your catalog but cannot place an order.'
            );
        } else {
            return $this->l('Visitors cannot see your catalog.');
        }
    }
    private function errorValueToMessage($error_value)
    {
        switch ($error_value) {
            case 1:
                $message = $this->l('The uploaded file exceeds the upload_max_filesize directive in php.ini');
                break;
            case 2:
                $message = $this->l('The uploaded file exceeds the MAX_FILE_SIZE directive');
                break;
            case 3:
                $message = $this->l('The uploaded file was only partially uploaded');
                break;
            case 4:
                $message = $this->l('No file was uploaded');
                break;
            case 6:
                $message = $this->l('Missing a temporary folder');
                break;
            case 7:
                $message = $this->l('Failed to write file to disk');
                break;
            case 8:
                $message = $this->l('File upload stopped by extension');
                break;
            default:
                $message = $this->l('Unknown upload error');
                break;
        }
        return $message;
    }
    public function postProcess()
    {
        $error = '';
        if (_PS_MODE_DEMO_) {
            return $this->displayError($this->l(
                'Demo Mode. Changes will not be saved.'
            ));
        }
        if (Tools::isSubmit('submitGeoTargetPro')) {
            $ips = (string)Tools::getValue('GTP_BLACK_LIST');
            $ips = explode("\n", $ips);
            foreach ($ips as $k => $ip) {
                $ip = trim($ip);
                if (!empty($ip) && count($ip)) {
                    $ips[$k] = $ip;
                } else {
                    unset($ips[$k]);
                }
            }
            $ips = implode(self::__GTP_BLACK_LIST_DELIM__, $ips);
            Configuration::updateValue('GTP_BLACK_LIST', (string)$ips);
            Configuration::updateValue(
                'GTP_DEFAULT_COUNTRY',
                (Tools::strtoupper(Tools::getValue('GTP_DEFAULT_COUNTRY')))
            );
            Configuration::updateValue('GTP_IP_CITY_INFO', (trim(Tools::getValue('GTP_IP_CITY_INFO'))));
            Configuration::updateValue('GTP_SYMTYPE', trim(Tools::getValue('GTP_SYMTYPE')));
            Configuration::updateValue('GTP_IPSIMULATOR', (bool)Tools::getValue('GTP_IPSIMULATOR'));
            Configuration::updateValue('GTP_ORG_IP_ADDR', trim(Tools::getValue('GTP_ORG_IP_ADDR')));
            Configuration::updateValue('GTP_IP2_SIMULATE', trim(Tools::getValue('GTP_IP2_SIMULATE')));
            Configuration::updateValue('GTP_COUNTRY2_SIMULATE', (Tools::getValue('GTP_COUNTRY2_SIMULATE')));
            Configuration::updateValue('GTP_GEO_STATS', (bool)(Tools::getValue('GTP_GEO_STATS')));
            Configuration::updateValue('GTP_ADDRESS_OVERRIDE', (bool)(Tools::getValue('GTP_ADDRESS_OVERRIDE')));
            Configuration::updateValue('GTP_ACTIVE_TAB', Tools::getValue('GTP_ACTIVE_TAB'));

            if ((bool)(Tools::getValue('GTP_GEO_STATS_CLEAR'))) {
                $now = date('Y-m-d H:i:00');
                Configuration::updateValue('GTP_STAT_LAST_CLEAR_DATE', $now);
                Configuration::updateValue('GTP_STAT_TOTAL', 0);
                Configuration::updateValue('GTP_STAT_RESOLVED', 0);
                Configuration::updateValue('GTP_STAT_NON_RESOLVED', 0);
            }
            if (filter_var(trim(Tools::getValue('GTP_IP_CITY_INFO')), FILTER_VALIDATE_IP) !== false) {
                Configuration::updateValue('GTP_IP_CITY_INFO', trim(Tools::getValue('GTP_IP_CITY_INFO')));
            } else {
                $error .= $this->displayError($this->l(
                    'Please enter a valid IP to resolve.'
                ));
            }

            if (Configuration::get('GTP_SYMTYPE') && Configuration::get('GTP_IP2_SIMULATE') == null) {
                Configuration::updateValue('GTP_IPSIMULATOR', 0);
                $error .= $this->displayError($this->l(
                    'Please enter an IP to simulate.'
                ));
            } elseif (!Configuration::get('GTP_SYMTYPE') && !Configuration::get('GTP_COUNTRY2_SIMULATE')) {
                Configuration::updateValue('GTP_IPSIMULATOR', 0);
                $error .= $this->displayError($this->l(
                    'Please select a country to simulate.'
                ));
            }
            if (!Configuration::get('GTP_ORG_IP_ADDR')) {
                Configuration::updateValue('GTP_IPSIMULATOR', 0);
                $error .= $this->displayError($this->l(
                    'Please enter IP of browser you are testing from.'
                ));
            }

            $post_max_size = Tools::getMaxUploadSize();
            $file_uploaded = false;
            if (isset($_FILES['GTP_GEOIP2_COUNTRY_FILE']) && $_FILES['GTP_GEOIP2_COUNTRY_FILE']['name'] != '') {
                if ($_FILES['GTP_GEOIP2_COUNTRY_FILE']['size'] > 0 &&
                    $_FILES['GTP_GEOIP2_COUNTRY_FILE']['size'] < $post_max_size) {
                    $file = $_FILES["GTP_GEOIP2_COUNTRY_FILE"];
                    $file_name = $file["name"];
                    $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                    $ext = Tools::strtolower($ext);

                    if ($ext != "mmdb") {
                        $error .= $this->displayError($this->l('Error: not a mmdb file'));
                    } else {
                        $saveto_path_and_name = _PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb';

                        if (move_uploaded_file($file["tmp_name"], $saveto_path_and_name)) {
                            $error .= $this->displayConfirmation($this->l(
                                'Upload successful'
                            ));
                        } else {
                            $error .= $this->displayError($this->l(
                                'Error Upload E00: could not upload file!'
                            ));
                        }
                        $file_uploaded = true;
                    }
                } else {
                    $upload_error = $_FILES['GTP_GEOIP2_COUNTRY_FILE']['error'];
                    if ($upload_error > 0) {
                        $error .= $this->displayError($this->codeToMessage($upload_error));
                    }
                }
                if ($_FILES['GTP_GEOIP2_COUNTRY_FILE']['size'] > $post_max_size) {
                    $error .= $this->displayError($this->l(
                        'The uploaded file exceeds the post_max_size directive in php.ini'
                    ));
                }
            }
            $error .= $this->displayConfirmation($this->l(
                'Settings updated'
            ));

            $primaryvalue = (int)Tools::getValue('GTP_PRIMARY_LOOKUP');
            $useridvalue = (int)Tools::getValue('GTP_MM_USER_ID');
            $licensevalue = (int)Tools::getValue('GTP_MM_LICENSE_KEY');
            if (($primaryvalue == 1) &&
                (!file_exists(_PS_MODULE_DIR_.$this->name.'/lib/geodata/GeoIP2-Country.mmdb') && !$file_uploaded)) {
                $primaryvalue = (int) Configuration::get('GTP_PRIMARY_LOOKUP');
                $error .= $this->displayError($this->l(
                    'Please upload GeoIP2-Country.mmdb first.'
                ));
            }
            if (($primaryvalue == 2) && ($useridvalue == '' || $licensevalue == '')) {
                $primaryvalue = (int) Configuration::get('GTP_PRIMARY_LOOKUP');
                $error .= $this->displayError($this->l(
                    'Please enter valid MaxMind user ID and license.'
                ));
            }
            Configuration::updateValue('GTP_PRIMARY_LOOKUP', $primaryvalue);
            Configuration::updateValue('GTP_MM_USER_ID', (Tools::getValue('GTP_MM_USER_ID')));
            Configuration::updateValue('GTP_MM_LICENSE_KEY', (Tools::getValue('GTP_MM_LICENSE_KEY')));
        }
        return $error;
    }
    public function displayWarning($warning)
    {
        $output = '
        <div class="bootstrap">
        <div class="module_warning alert alert-warning" >
            <button type="button" class="close" data-dismiss="alert">&times;</button>';

        if (is_array($warning)) {
            $output .= '<ul>';
            foreach ($warning as $msg) {
                $output .= '<li>'.$msg.'</li>';
            }
            $output .= '</ul>';
        } else {
            $output .= $warning;
        }

        // Close div openned previously
        $output .= '</div></div>';

        return $output;
    }
}
